/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx.game;

import com.gamelion.speedx.Debug;
import com.gamelion.speedx.Utils;
import com.gamelion.speedx.game.Matrix4f;
import com.gamelion.speedx.game.Vector3f;
import java.util.Random;

public class Spline {
    private static final float STEP = 0.005f;
    private static final float NODE_HALF_DISTANCE = 12.5f;
    private static final float NODE_ANGLE_MAX = 1.0471976f;
    private Node[] nodes = new Node[8];
    private float segmentLen;
    private float t0 = 0.0f;
    private float current = 1.0f;
    private Matrix4f mtx = new Matrix4f();
    private Random rng;
    private Vector3f start = new Vector3f();
    private Vector3f p = new Vector3f();

    public Spline(float segmentLen, Random rand) {
        this.rng = rand;
        this.t0 = 0.0f;
        this.current = 1.0f;
        this.segmentLen = segmentLen;
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i] = new Node();
        }
    }

    public void begin(Vector3f p, Vector3f m) {
        int i;
        this.mtx.setIdentity();
        this.mtx.setupRotate(0.0f, (float)(2.0 * (2.0 * (double)this.rng.nextFloat() - 1.0) * 1.0471975803375244 / 3.0), (float)(2.0 * (2.0 * (double)this.rng.nextFloat() - 1.0) * 1.0471975803375244 / 3.0));
        for (i = 0; i < 4; ++i) {
            this.nodes[i].p.set(0.0f, 0.0f, (float)i * 12.5f * this.segmentLen);
        }
        for (i = 4; i < this.nodes.length; ++i) {
            this.addPointAt(i);
        }
        this.nodes[0].m.set(this.nodes[1].p.x - this.nodes[0].p.x, this.nodes[1].p.y - this.nodes[0].p.y, this.nodes[1].p.z - this.nodes[0].p.z);
        for (i = 1; i < this.nodes.length - 1; ++i) {
            this.tangentAt(i);
        }
        this.current = 1.0f;
        this.t0 = 0.0f;
        this.interpolate(this.current, p, m);
    }

    public void next(Vector3f p, Vector3f m) {
        this.current = this.reparametrize(this.current, this.segmentLen);
        this.interpolate(this.current, p, m);
        this.generateNextSegment(this.current);
    }

    private void interpolate(float t, Vector3f p) {
        int n = (int)(t - this.t0);
        t = t - (float)n - this.t0;
        float _1_t = 1.0f - t;
        float _1_t2 = _1_t * _1_t;
        float t2 = t * t;
        float _2t = 2.0f * t;
        float h00 = (1.0f + _2t) * _1_t2;
        float h10 = t * _1_t2;
        float h01 = t2 * (3.0f - _2t);
        float h11 = -t2 * _1_t;
        p.set(this.nodes[n].p.x * h00 + this.nodes[n].m.x * h10 + this.nodes[n + 1].p.x * h01 + this.nodes[n + 1].m.x * h11, this.nodes[n].p.y * h00 + this.nodes[n].m.y * h10 + this.nodes[n + 1].p.y * h01 + this.nodes[n + 1].m.y * h11, this.nodes[n].p.z * h00 + this.nodes[n].m.z * h10 + this.nodes[n + 1].p.z * h01 + this.nodes[n + 1].m.z * h11);
    }

    private void interpolate(float t, Vector3f p, Vector3f m) {
        int n = (int)(t - this.t0);
        t = t - (float)n - this.t0;
        float _1_t = 1.0f - t;
        float _1_t2 = _1_t * _1_t;
        float t2 = t * t;
        float _2t = 2.0f * t;
        float _3t2 = 3.0f * t2;
        float h00 = (1.0f + _2t) * _1_t2;
        float h10 = t * _1_t2;
        float h01 = t2 * (3.0f - _2t);
        float h11 = -t2 * _1_t;
        float th00 = -6.0f * t * _1_t;
        float th10 = _3t2 - 4.0f * t + 1.0f;
        float th01 = -th00;
        float th11 = _3t2 - _2t;
        p.set(this.nodes[n].p.x * h00 + this.nodes[n].m.x * h10 + this.nodes[n + 1].p.x * h01 + this.nodes[n + 1].m.x * h11, this.nodes[n].p.y * h00 + this.nodes[n].m.y * h10 + this.nodes[n + 1].p.y * h01 + this.nodes[n + 1].m.y * h11, this.nodes[n].p.z * h00 + this.nodes[n].m.z * h10 + this.nodes[n + 1].p.z * h01 + this.nodes[n + 1].m.z * h11);
        m.set(this.nodes[n].p.x * th00 + this.nodes[n].m.x * th10 + this.nodes[n + 1].p.x * th01 + this.nodes[n + 1].m.x * th11, this.nodes[n].p.y * th00 + this.nodes[n].m.y * th10 + this.nodes[n + 1].p.y * th01 + this.nodes[n + 1].m.y * th11, this.nodes[n].p.z * th00 + this.nodes[n].m.z * th10 + this.nodes[n + 1].p.z * th01 + this.nodes[n + 1].m.z * th11);
        m.normalize();
    }

    private float reparametrize(float t, float arclen) {
        float arclen2 = arclen * arclen;
        float lastT = t;
        float lastLen2 = 0.0f;
        float currentLen2 = 0.0f;
        this.interpolate(t, this.start);
        do {
            lastT = t;
            lastLen2 = currentLen2;
            this.interpolate(t += 0.005f, this.p);
        } while ((currentLen2 = Vector3f.distanceSqr(this.start, this.p)) < arclen2);
        lastLen2 = (float)Math.sqrt(lastLen2);
        currentLen2 = (float)Math.sqrt(currentLen2);
        return Utils.lerp(lastT, t, (arclen - lastLen2) / (currentLen2 - lastLen2));
    }

    private void generateNextSegment(float t) {
        if (t - this.t0 > (float)this.nodes.length - 3.0f) {
            for (int i = 0; i < this.nodes.length - 1; ++i) {
                this.nodes[i].m.x = this.nodes[i + 1].m.x;
                this.nodes[i].m.y = this.nodes[i + 1].m.y;
                this.nodes[i].m.z = this.nodes[i + 1].m.z;
                this.nodes[i].p.x = this.nodes[i + 1].p.x;
                this.nodes[i].p.y = this.nodes[i + 1].p.y;
                this.nodes[i].p.z = this.nodes[i + 1].p.z;
            }
            this.t0 += 1.0f;
            this.addPointAt(this.nodes.length - 1);
            this.tangentAt(this.nodes.length - 2);
        }
    }

    private void addPointAt(int ndx) {
        float rand = this.rng.nextFloat();
        float distance = 12.5f + 12.5f * rand;
        float angleMax = (2.0943952f + rand * 1.0471976f) / 3.0f;
        Debug.trace("rotation fixed to zero");
        if (0 == (this.rng.nextInt() & 1)) {
            this.mtx.setRotation(0.0f, (2.0f * this.rng.nextFloat() - 1.0f) * angleMax, (2.0f * this.rng.nextFloat() - 1.0f) * angleMax);
        }
        this.p.set(this.nodes[ndx - 1].p.x - this.nodes[ndx - 2].p.x, this.nodes[ndx - 1].p.y - this.nodes[ndx - 2].p.y, this.nodes[ndx - 1].p.z - this.nodes[ndx - 2].p.z);
        this.p.normalize();
        this.mtx.rotate(this.p, this.p);
        this.nodes[ndx].p.set(this.p.x * distance * this.segmentLen + this.nodes[ndx - 1].p.x, this.p.y * distance * this.segmentLen + this.nodes[ndx - 1].p.y, this.p.z * distance * this.segmentLen + this.nodes[ndx - 1].p.z);
    }

    private void tangentAt(int ndx) {
        this.nodes[ndx].m.set((this.nodes[ndx + 1].p.x - this.nodes[ndx - 1].p.x) * 0.5f, (this.nodes[ndx + 1].p.y - this.nodes[ndx - 1].p.y) * 0.5f, (this.nodes[ndx + 1].p.z - this.nodes[ndx - 1].p.z) * 0.5f);
    }

    private class Node {
        public Vector3f p = new Vector3f();
        public Vector3f m = new Vector3f();

        private Node() {
        }
    }
}

